library(rstatix)
library(xlsx)

###IMPORT & FORMAT DATA###

Data.norm <- read.xlsx("Segment_Lengths_Volumes.xlsx", sheetIndex = 1, header = TRUE, row.names = 1)
Data.raw <- read.xlsx("Segment_Lengths_Volumes.xlsx", sheetIndex = 2, header = TRUE, row.names = 1)

###Linear Raw###

R_L_Humerus_aov <- anova_test(data = Data.raw, L_Humerus ~ Breed) 
R_L_Humerus_pwc <- aov(data = Data.raw, L_Humerus ~ Breed) %>% tukey_hsd()
R_L_Humerus <- data.frame(c(R_L_Humerus_aov[,c(4:5,7)], R_L_Humerus_pwc[1,8], R_L_Humerus_pwc[2,8], R_L_Humerus_pwc[3,8]), row.names = 'R_L_Humerus')

R_L_Forearm_aov <- anova_test(data = Data.raw, L_Forearm ~ Breed) 
R_L_Forearm_pwc <- aov(data = Data.raw, L_Forearm ~ Breed) %>% tukey_hsd()
R_L_Forearm <- data.frame(c(R_L_Forearm_aov[,c(4:5,7)], R_L_Forearm_pwc[1,8], R_L_Forearm_pwc[2,8], R_L_Forearm_pwc[3,8]), row.names = 'R_L_Forearm')

R_L_CMC_aov <- anova_test(data = Data.raw, L_CMC ~ Breed) 
R_L_CMC_pwc <- aov(data = Data.raw, L_CMC ~ Breed) %>% tukey_hsd()
R_L_CMC <- data.frame(c(R_L_CMC_aov[,c(4:5,7)], R_L_CMC_pwc[1,8], R_L_CMC_pwc[2,8], R_L_CMC_pwc[3,8]), row.names = 'R_L_CMC')

R_L_Manus_aov <- anova_test(data = Data.raw, L_Manus ~ Breed) 
R_L_Manus_pwc <- aov(data = Data.raw, L_Manus ~ Breed) %>% tukey_hsd()
R_L_Manus <- data.frame(c(R_L_Manus_aov[,c(4:5,7)], R_L_Manus_pwc[1,8], R_L_Manus_pwc[2,8], R_L_Manus_pwc[3,8]), row.names = 'R_L_Manus')

R_L_TotalFore_aov <- anova_test(data = Data.raw, L_TotalFore ~ Breed) 
R_L_TotalFore_pwc <- aov(data = Data.raw, L_TotalFore ~ Breed) %>% tukey_hsd()
R_L_TotalFore <- data.frame(c(R_L_TotalFore_aov[,c(4:5,7)], R_L_TotalFore_pwc[1,8], R_L_TotalFore_pwc[2,8], R_L_TotalFore_pwc[3,8]), row.names = 'R_L_TotalFore')

R_L_Thigh_aov <- anova_test(data = Data.raw, L_Thigh ~ Breed) 
R_L_Thigh_pwc <- aov(data = Data.raw, L_Thigh ~ Breed) %>% tukey_hsd()
R_L_Thigh <- data.frame(c(R_L_Thigh_aov[,c(4:5,7)], R_L_Thigh_pwc[1,8], R_L_Thigh_pwc[2,8], R_L_Thigh_pwc[3,8]), row.names = 'R_L_Thigh')

R_L_Shank_aov <- anova_test(data = Data.raw, L_Shank ~ Breed) 
R_L_Shank_pwc <- aov(data = Data.raw, L_Shank ~ Breed) %>% tukey_hsd()
R_L_Shank <- data.frame(c(R_L_Shank_aov[,c(4:5,7)], R_L_Shank_pwc[1,8], R_L_Shank_pwc[2,8], R_L_Shank_pwc[3,8]), row.names = 'R_L_Shank')

R_L_TMT_aov <- anova_test(data = Data.raw, L_TMT ~ Breed) 
R_L_TMT_pwc <- aov(data = Data.raw, L_TMT ~ Breed) %>% tukey_hsd()
R_L_TMT <- data.frame(c(R_L_TMT_aov[,c(4:5,7)], R_L_TMT_pwc[1,8], R_L_TMT_pwc[2,8], R_L_TMT_pwc[3,8]), row.names = 'R_L_TMT')

R_L_Pes_aov <- anova_test(data = Data.raw, L_Pes ~ Breed) 
R_L_Pes_pwc <- aov(data = Data.raw, L_Pes ~ Breed) %>% tukey_hsd()
R_L_Pes <- data.frame(c(R_L_Pes_aov[,c(4:5,7)], R_L_Pes_pwc[1,8], R_L_Pes_pwc[2,8], R_L_Pes_pwc[3,8]), row.names = 'R_L_Pes')

R_L_TotalHind_aov <- anova_test(data = Data.raw, L_TotalHind ~ Breed) 
R_L_TotalHind_pwc <- aov(data = Data.raw, L_TotalHind ~ Breed) %>% tukey_hsd()
R_L_TotalHind <- data.frame(c(R_L_TotalHind_aov[,c(4:5,7)], R_L_TotalHind_pwc[1,8], R_L_TotalHind_pwc[2,8], R_L_TotalHind_pwc[3,8]), row.names = 'R_L_TotalHind')

R_L_Neck_aov <- anova_test(data = Data.raw, L_Neck ~ Breed) 
R_L_Neck_pwc <- aov(data = Data.raw, L_Neck ~ Breed) %>% tukey_hsd()
R_L_Neck <- data.frame(c(R_L_Neck_aov[,c(4:5,7)], R_L_Neck_pwc[1,8], R_L_Neck_pwc[2,8], R_L_Neck_pwc[3,8]), row.names = 'R_L_Neck')

R_L_Shoulder_aov <- anova_test(data = Data.raw, L_Shoulder ~ Breed) 
R_L_Shoulder_pwc <- aov(data = Data.raw, L_Shoulder ~ Breed) %>% tukey_hsd()
R_L_Shoulder <- data.frame(c(R_L_Shoulder_aov[,c(4:5,7)], R_L_Shoulder_pwc[1,8], R_L_Shoulder_pwc[2,8], R_L_Shoulder_pwc[3,8]), row.names = 'R_L_Shoulder')

R_L_Sternum_aov <- anova_test(data = Data.raw, L_Sternum ~ Breed) 
R_L_Sternum_pwc <- aov(data = Data.raw, L_Sternum ~ Breed) %>% tukey_hsd()
R_L_Sternum <- data.frame(c(R_L_Sternum_aov[,c(4:5,7)], R_L_Sternum_pwc[1,8], R_L_Sternum_pwc[2,8], R_L_Sternum_pwc[3,8]), row.names = 'R_L_Sternum')

R_L_GA_aov <- anova_test(data = Data.raw, L_GA ~ Breed) 
R_L_GA_pwc <- aov(data = Data.raw, L_GA ~ Breed) %>% tukey_hsd()
R_L_GA <- data.frame(c(R_L_GA_aov[,c(4:5,7)], R_L_GA_pwc[1,8], R_L_GA_pwc[2,8], R_L_GA_pwc[3,8]), row.names = 'R_L_GA')

R_L_Hip_aov <- anova_test(data = Data.raw, L_Hip ~ Breed) 
R_L_Hip_pwc <- aov(data = Data.raw, L_Hip ~ Breed) %>% tukey_hsd()
R_L_Hip <- data.frame(c(R_L_Hip_aov[,c(4:5,7)], R_L_Hip_pwc[1,8], R_L_Hip_pwc[2,8], R_L_Hip_pwc[3,8]), row.names = 'R_L_Hip')

###Hulls Raw###

R_H_Head_aov <- anova_test(data = Data.raw, H_Head ~ Breed) 
R_H_Head_pwc <- aov(data = Data.raw, H_Head ~ Breed) %>% tukey_hsd()
R_H_Head <- data.frame(c(R_H_Head_aov[,c(4:5,7)], R_H_Head_pwc[1,8], R_H_Head_pwc[2,8], R_H_Head_pwc[3,8]), row.names = 'R_H_Head')

R_H_Neck_aov <- anova_test(data = Data.raw, H_Neck ~ Breed) 
R_H_Neck_pwc <- aov(data = Data.raw, H_Neck ~ Breed) %>% tukey_hsd()
R_H_Neck <- data.frame(c(R_H_Neck_aov[,c(4:5,7)], R_H_Neck_pwc[1,8], R_H_Neck_pwc[2,8], R_H_Neck_pwc[3,8]), row.names = 'R_H_Neck')

R_H_Torso_aov <- anova_test(data = Data.raw, H_Torso ~ Breed) 
R_H_Torso_pwc <- aov(data = Data.raw, H_Torso ~ Breed) %>% tukey_hsd()
R_H_Torso <- data.frame(c(R_H_Torso_aov[,c(4:5,7)], R_H_Torso_pwc[1,8], R_H_Torso_pwc[2,8], R_H_Torso_pwc[3,8]), row.names = 'R_H_Torso')

R_H_Humerus_aov <- anova_test(data = Data.raw, H_Humerus ~ Breed) 
R_H_Humerus_pwc <- aov(data = Data.raw, H_Humerus ~ Breed) %>% tukey_hsd()
R_H_Humerus <- data.frame(c(R_H_Humerus_aov[,c(4:5,7)], R_H_Humerus_pwc[1,8], R_H_Humerus_pwc[2,8], R_H_Humerus_pwc[3,8]), row.names = 'R_H_Humerus')

R_H_Forearm_aov <- anova_test(data = Data.raw, H_Forearm ~ Breed) 
R_H_Forearm_pwc <- aov(data = Data.raw, H_Forearm ~ Breed) %>% tukey_hsd()
R_H_Forearm <- data.frame(c(R_H_Forearm_aov[,c(4:5,7)], R_H_Forearm_pwc[1,8], R_H_Forearm_pwc[2,8], R_H_Forearm_pwc[3,8]), row.names = 'R_H_Forearm')

R_H_Manus_aov <- anova_test(data = Data.raw, H_Manus ~ Breed) 
R_H_Manus_pwc <- aov(data = Data.raw, H_Manus ~ Breed) %>% tukey_hsd()
R_H_Manus <- data.frame(c(R_H_Manus_aov[,c(4:5,7)], R_H_Manus_pwc[1,8], R_H_Manus_pwc[2,8], R_H_Manus_pwc[3,8]), row.names = 'R_H_Manus')

R_H_Thigh_aov <- anova_test(data = Data.raw, H_Thigh ~ Breed) 
R_H_Thigh_pwc <- aov(data = Data.raw, H_Thigh ~ Breed) %>% tukey_hsd()
R_H_Thigh <- data.frame(c(R_H_Thigh_aov[,c(4:5,7)], R_H_Thigh_pwc[1,8], R_H_Thigh_pwc[2,8], R_H_Thigh_pwc[3,8]), row.names = 'R_H_Thigh')

R_H_Shank_aov <- anova_test(data = Data.raw, H_Shank ~ Breed) 
R_H_Shank_pwc <- aov(data = Data.raw, H_Shank ~ Breed) %>% tukey_hsd()
R_H_Shank <- data.frame(c(R_H_Shank_aov[,c(4:5,7)], R_H_Shank_pwc[1,8], R_H_Shank_pwc[2,8], R_H_Shank_pwc[3,8]), row.names = 'R_H_Shank')

R_H_TMT_aov <- anova_test(data = Data.raw, H_TMT ~ Breed) 
R_H_TMT_pwc <- aov(data = Data.raw, H_TMT ~ Breed) %>% tukey_hsd()
R_H_TMT <- data.frame(c(R_H_TMT_aov[,c(4:5,7)], R_H_TMT_pwc[1,8], R_H_TMT_pwc[2,8], R_H_TMT_pwc[3,8]), row.names = 'R_H_TMT')

R_H_Pes_aov <- anova_test(data = Data.raw, H_Pes ~ Breed) 
R_H_Pes_pwc <- aov(data = Data.raw, H_Pes ~ Breed) %>% tukey_hsd()
R_H_Pes <- data.frame(c(R_H_Pes_aov[,c(4:5,7)], R_H_Pes_pwc[1,8], R_H_Pes_pwc[2,8], R_H_Pes_pwc[3,8]), row.names = 'R_H_Pes')

###Skins Raw###

R_S_Head_aov <- anova_test(data = Data.raw, S_Head ~ Breed) 
R_S_Head_pwc <- aov(data = Data.raw, S_Head ~ Breed) %>% tukey_hsd()
R_S_Head <- data.frame(c(R_S_Head_aov[,c(4:5,7)], R_S_Head_pwc[1,8], R_S_Head_pwc[2,8], R_S_Head_pwc[3,8]), row.names = 'R_S_Head')

R_S_Neck_aov <- anova_test(data = Data.raw, S_Neck ~ Breed) 
R_S_Neck_pwc <- aov(data = Data.raw, S_Neck ~ Breed) %>% tukey_hsd()
R_S_Neck <- data.frame(c(R_S_Neck_aov[,c(4:5,7)], R_S_Neck_pwc[1,8], R_S_Neck_pwc[2,8], R_S_Neck_pwc[3,8]), row.names = 'R_S_Neck')

R_S_Torso_aov <- anova_test(data = Data.raw, S_Torso ~ Breed) 
R_S_Torso_pwc <- aov(data = Data.raw, S_Torso ~ Breed) %>% tukey_hsd()
R_S_Torso <- data.frame(c(R_S_Torso_aov[,c(4:5,7)], R_S_Torso_pwc[1,8], R_S_Torso_pwc[2,8], R_S_Torso_pwc[3,8]), row.names = 'R_S_Torso')

R_S_Humerus_aov <- anova_test(data = Data.raw, S_Humerus ~ Breed) 
R_S_Humerus_pwc <- aov(data = Data.raw, S_Humerus ~ Breed) %>% tukey_hsd()
R_S_Humerus <- data.frame(c(R_S_Humerus_aov[,c(4:5,7)], R_S_Humerus_pwc[1,8], R_S_Humerus_pwc[2,8], R_S_Humerus_pwc[3,8]), row.names = 'R_S_Humerus')

R_S_Forearm_aov <- anova_test(data = Data.raw, S_Forearm ~ Breed) 
R_S_Forearm_pwc <- aov(data = Data.raw, S_Forearm ~ Breed) %>% tukey_hsd()
R_S_Forearm <- data.frame(c(R_S_Forearm_aov[,c(4:5,7)], R_S_Forearm_pwc[1,8], R_S_Forearm_pwc[2,8], R_S_Forearm_pwc[3,8]), row.names = 'R_S_Forearm')

R_S_Manus_aov <- anova_test(data = Data.raw, S_Manus ~ Breed) 
R_S_Manus_pwc <- aov(data = Data.raw, S_Manus ~ Breed) %>% tukey_hsd()
R_S_Manus <- data.frame(c(R_S_Manus_aov[,c(4:5,7)], R_S_Manus_pwc[1,8], R_S_Manus_pwc[2,8], R_S_Manus_pwc[3,8]), row.names = 'R_S_Manus')

R_S_ThigS_aov <- anova_test(data = Data.raw, S_Thigh ~ Breed) 
R_S_ThigS_pwc <- aov(data = Data.raw, S_Thigh ~ Breed) %>% tukey_hsd()
R_S_Thigh <- data.frame(c(R_S_ThigS_aov[,c(4:5,7)], R_S_ThigS_pwc[1,8], R_S_ThigS_pwc[2,8], R_S_ThigS_pwc[3,8]), row.names = 'R_S_Thigh')

R_S_Shank_aov <- anova_test(data = Data.raw, S_Shank ~ Breed) 
R_S_Shank_pwc <- aov(data = Data.raw, S_Shank ~ Breed) %>% tukey_hsd()
R_S_Shank <- data.frame(c(R_S_Shank_aov[,c(4:5,7)], R_S_Shank_pwc[1,8], R_S_Shank_pwc[2,8], R_S_Shank_pwc[3,8]), row.names = 'R_S_Shank')

R_S_TMT_aov <- anova_test(data = Data.raw, S_TMT ~ Breed) 
R_S_TMT_pwc <- aov(data = Data.raw, S_TMT ~ Breed) %>% tukey_hsd()
R_S_TMT <- data.frame(c(R_S_TMT_aov[,c(4:5,7)], R_S_TMT_pwc[1,8], R_S_TMT_pwc[2,8], R_S_TMT_pwc[3,8]), row.names = 'R_S_TMT')

R_S_Pes_aov <- anova_test(data = Data.raw, S_Pes ~ Breed) 
R_S_Pes_pwc <- aov(data = Data.raw, S_Pes ~ Breed) %>% tukey_hsd()
R_S_Pes <- data.frame(c(R_S_Pes_aov[,c(4:5,7)], R_S_Pes_pwc[1,8], R_S_Pes_pwc[2,8], R_S_Pes_pwc[3,8]), row.names = 'R_S_Pes')

###Format Raw AOV Results###
R_List <- do.call("rbind", list(
R_L_Humerus, R_L_Forearm, R_L_CMC, R_L_Manus, R_L_Thigh, R_L_Shank, R_L_TMT, R_L_Pes, R_L_Neck, 
R_L_Shoulder, R_L_Sternum, R_L_GA, R_L_Hip,
R_H_Head, R_H_Neck, R_H_Torso, R_H_Humerus, R_H_Forearm, R_H_Manus, R_H_Thigh, R_H_Shank, R_H_TMT, R_H_Pes,
R_S_Head, R_S_Neck, R_S_Torso, R_S_Humerus, R_S_Forearm, R_S_Manus, R_S_Thigh, R_S_Shank, R_S_TMT, R_S_Pes))


###Linear Normalised###

N_L_Humerus_aov <- anova_test(data = Data.norm, L_Humerus ~ Breed) 
N_L_Humerus_pwc <- aov(data = Data.norm, L_Humerus ~ Breed) %>% tukey_hsd()
N_L_Humerus <- data.frame(c(N_L_Humerus_aov[,c(4:5,7)], N_L_Humerus_pwc[1,8], N_L_Humerus_pwc[2,8], N_L_Humerus_pwc[3,8]), row.names = 'N_L_Humerus')

N_L_Forearm_aov <- anova_test(data = Data.norm, L_Forearm ~ Breed) 
N_L_Forearm_pwc <- aov(data = Data.norm, L_Forearm ~ Breed) %>% tukey_hsd()
N_L_Forearm <- data.frame(c(N_L_Forearm_aov[,c(4:5,7)], N_L_Forearm_pwc[1,8], N_L_Forearm_pwc[2,8], N_L_Forearm_pwc[3,8]), row.names = 'N_L_Forearm')

N_L_CMC_aov <- anova_test(data = Data.norm, L_CMC ~ Breed) 
N_L_CMC_pwc <- aov(data = Data.norm, L_CMC ~ Breed) %>% tukey_hsd()
N_L_CMC <- data.frame(c(N_L_CMC_aov[,c(4:5,7)], N_L_CMC_pwc[1,8], N_L_CMC_pwc[2,8], N_L_CMC_pwc[3,8]), row.names = 'N_L_CMC')

N_L_Manus_aov <- anova_test(data = Data.norm, L_Manus ~ Breed) 
N_L_Manus_pwc <- aov(data = Data.norm, L_Manus ~ Breed) %>% tukey_hsd()
N_L_Manus <- data.frame(c(N_L_Manus_aov[,c(4:5,7)], N_L_Manus_pwc[1,8], N_L_Manus_pwc[2,8], N_L_Manus_pwc[3,8]), row.names = 'N_L_Manus')

N_L_TotalFore_aov <- anova_test(data = Data.norm, L_TotalFore ~ Breed) 
N_L_TotalFore_pwc <- aov(data = Data.norm, L_TotalFore ~ Breed) %>% tukey_hsd()
N_L_TotalFore <- data.frame(c(N_L_TotalFore_aov[,c(4:5,7)], N_L_TotalFore_pwc[1,8], N_L_TotalFore_pwc[2,8], N_L_TotalFore_pwc[3,8]), row.names = 'N_L_TotalFore')

N_L_Thigh_aov <- anova_test(data = Data.norm, L_Thigh ~ Breed) 
N_L_Thigh_pwc <- aov(data = Data.norm, L_Thigh ~ Breed) %>% tukey_hsd()
N_L_Thigh <- data.frame(c(N_L_Thigh_aov[,c(4:5,7)], N_L_Thigh_pwc[1,8], N_L_Thigh_pwc[2,8], N_L_Thigh_pwc[3,8]), row.names = 'N_L_Thigh')

N_L_Shank_aov <- anova_test(data = Data.norm, L_Shank ~ Breed) 
N_L_Shank_pwc <- aov(data = Data.norm, L_Shank ~ Breed) %>% tukey_hsd()
N_L_Shank <- data.frame(c(N_L_Shank_aov[,c(4:5,7)], N_L_Shank_pwc[1,8], N_L_Shank_pwc[2,8], N_L_Shank_pwc[3,8]), row.names = 'N_L_Shank')

N_L_TMT_aov <- anova_test(data = Data.norm, L_TMT ~ Breed) 
N_L_TMT_pwc <- aov(data = Data.norm, L_TMT ~ Breed) %>% tukey_hsd()
N_L_TMT <- data.frame(c(N_L_TMT_aov[,c(4:5,7)], N_L_TMT_pwc[1,8], N_L_TMT_pwc[2,8], N_L_TMT_pwc[3,8]), row.names = 'N_L_TMT')

N_L_Pes_aov <- anova_test(data = Data.norm, L_Pes ~ Breed) 
N_L_Pes_pwc <- aov(data = Data.norm, L_Pes ~ Breed) %>% tukey_hsd()
N_L_Pes <- data.frame(c(N_L_Pes_aov[,c(4:5,7)], N_L_Pes_pwc[1,8], N_L_Pes_pwc[2,8], N_L_Pes_pwc[3,8]), row.names = 'N_L_Pes')

N_L_TotalHind_aov <- anova_test(data = Data.norm, L_TotalHind ~ Breed) 
N_L_TotalHind_pwc <- aov(data = Data.norm, L_TotalHind ~ Breed) %>% tukey_hsd()
N_L_TotalHind <- data.frame(c(N_L_TotalHind_aov[,c(4:5,7)], N_L_TotalHind_pwc[1,8], N_L_TotalHind_pwc[2,8], N_L_TotalHind_pwc[3,8]), row.names = 'N_L_TotalHind')

N_L_Neck_aov <- anova_test(data = Data.norm, L_Neck ~ Breed) 
N_L_Neck_pwc <- aov(data = Data.norm, L_Neck ~ Breed) %>% tukey_hsd()
N_L_Neck <- data.frame(c(N_L_Neck_aov[,c(4:5,7)], N_L_Neck_pwc[1,8], N_L_Neck_pwc[2,8], N_L_Neck_pwc[3,8]), row.names = 'N_L_Neck')

N_L_ShouldeN_aov <- anova_test(data = Data.norm, L_Shoulder ~ Breed) 
N_L_ShouldeN_pwc <- aov(data = Data.norm, L_Shoulder ~ Breed) %>% tukey_hsd()
N_L_Shoulder <- data.frame(c(N_L_ShouldeN_aov[,c(4:5,7)], N_L_ShouldeN_pwc[1,8], N_L_ShouldeN_pwc[2,8], N_L_ShouldeN_pwc[3,8]), row.names = 'N_L_Shoulder')

N_L_Sternum_aov <- anova_test(data = Data.norm, L_Sternum ~ Breed) 
N_L_Sternum_pwc <- aov(data = Data.norm, L_Sternum ~ Breed) %>% tukey_hsd()
N_L_Sternum <- data.frame(c(N_L_Sternum_aov[,c(4:5,7)], N_L_Sternum_pwc[1,8], N_L_Sternum_pwc[2,8], N_L_Sternum_pwc[3,8]), row.names = 'N_L_Sternum')

N_L_GA_aov <- anova_test(data = Data.norm, L_GA ~ Breed) 
N_L_GA_pwc <- aov(data = Data.norm, L_GA ~ Breed) %>% tukey_hsd()
N_L_GA <- data.frame(c(N_L_GA_aov[,c(4:5,7)], N_L_GA_pwc[1,8], N_L_GA_pwc[2,8], N_L_GA_pwc[3,8]), row.names = 'N_L_GA')

N_L_Hip_aov <- anova_test(data = Data.norm, L_Hip ~ Breed) 
N_L_Hip_pwc <- aov(data = Data.norm, L_Hip ~ Breed) %>% tukey_hsd()
N_L_Hip <- data.frame(c(N_L_Hip_aov[,c(4:5,7)], N_L_Hip_pwc[1,8], N_L_Hip_pwc[2,8], N_L_Hip_pwc[3,8]), row.names = 'N_L_Hip')

###Hulls Normalised###

N_H_Head_aov <- anova_test(data = Data.norm, H_Head ~ Breed) 
N_H_Head_pwc <- aov(data = Data.norm, H_Head ~ Breed) %>% tukey_hsd()
N_H_Head <- data.frame(c(N_H_Head_aov[,c(4:5,7)], N_H_Head_pwc[1,8], N_H_Head_pwc[2,8], N_H_Head_pwc[3,8]), row.names = 'N_H_Head')

N_H_Neck_aov <- anova_test(data = Data.norm, H_Neck ~ Breed) 
N_H_Neck_pwc <- aov(data = Data.norm, H_Neck ~ Breed) %>% tukey_hsd()
N_H_Neck <- data.frame(c(N_H_Neck_aov[,c(4:5,7)], N_H_Neck_pwc[1,8], N_H_Neck_pwc[2,8], N_H_Neck_pwc[3,8]), row.names = 'N_H_Neck')

N_H_Torso_aov <- anova_test(data = Data.norm, H_Torso ~ Breed) 
N_H_Torso_pwc <- aov(data = Data.norm, H_Torso ~ Breed) %>% tukey_hsd()
N_H_Torso <- data.frame(c(N_H_Torso_aov[,c(4:5,7)], N_H_Torso_pwc[1,8], N_H_Torso_pwc[2,8], N_H_Torso_pwc[3,8]), row.names = 'N_H_Torso')

N_H_Humerus_aov <- anova_test(data = Data.norm, H_Humerus ~ Breed) 
N_H_Humerus_pwc <- aov(data = Data.norm, H_Humerus ~ Breed) %>% tukey_hsd()
N_H_Humerus <- data.frame(c(N_H_Humerus_aov[,c(4:5,7)], N_H_Humerus_pwc[1,8], N_H_Humerus_pwc[2,8], N_H_Humerus_pwc[3,8]), row.names = 'N_H_Humerus')

N_H_Forearm_aov <- anova_test(data = Data.norm, H_Forearm ~ Breed) 
N_H_Forearm_pwc <- aov(data = Data.norm, H_Forearm ~ Breed) %>% tukey_hsd()
N_H_Forearm <- data.frame(c(N_H_Forearm_aov[,c(4:5,7)], N_H_Forearm_pwc[1,8], N_H_Forearm_pwc[2,8], N_H_Forearm_pwc[3,8]), row.names = 'N_H_Forearm')

N_H_Manus_aov <- anova_test(data = Data.norm, H_Manus ~ Breed) 
N_H_Manus_pwc <- aov(data = Data.norm, H_Manus ~ Breed) %>% tukey_hsd()
N_H_Manus <- data.frame(c(N_H_Manus_aov[,c(4:5,7)], N_H_Manus_pwc[1,8], N_H_Manus_pwc[2,8], N_H_Manus_pwc[3,8]), row.names = 'N_H_Manus')

N_H_Thigh_aov <- anova_test(data = Data.norm, H_Thigh ~ Breed) 
N_H_Thigh_pwc <- aov(data = Data.norm, H_Thigh ~ Breed) %>% tukey_hsd()
N_H_Thigh <- data.frame(c(N_H_Thigh_aov[,c(4:5,7)], N_H_Thigh_pwc[1,8], N_H_Thigh_pwc[2,8], N_H_Thigh_pwc[3,8]), row.names = 'N_H_Thigh')

N_H_Shank_aov <- anova_test(data = Data.norm, H_Shank ~ Breed) 
N_H_Shank_pwc <- aov(data = Data.norm, H_Shank ~ Breed) %>% tukey_hsd()
N_H_Shank <- data.frame(c(N_H_Shank_aov[,c(4:5,7)], N_H_Shank_pwc[1,8], N_H_Shank_pwc[2,8], N_H_Shank_pwc[3,8]), row.names = 'N_H_Shank')

N_H_TMT_aov <- anova_test(data = Data.norm, H_TMT ~ Breed) 
N_H_TMT_pwc <- aov(data = Data.norm, H_TMT ~ Breed) %>% tukey_hsd()
N_H_TMT <- data.frame(c(N_H_TMT_aov[,c(4:5,7)], N_H_TMT_pwc[1,8], N_H_TMT_pwc[2,8], N_H_TMT_pwc[3,8]), row.names = 'N_H_TMT')

N_H_Pes_aov <- anova_test(data = Data.norm, H_Pes ~ Breed) 
N_H_Pes_pwc <- aov(data = Data.norm, H_Pes ~ Breed) %>% tukey_hsd()
N_H_Pes <- data.frame(c(N_H_Pes_aov[,c(4:5,7)], N_H_Pes_pwc[1,8], N_H_Pes_pwc[2,8], N_H_Pes_pwc[3,8]), row.names = 'N_H_Pes')

###Skins Normalised###

N_S_Head_aov <- anova_test(data = Data.norm, S_Head ~ Breed) 
N_S_Head_pwc <- aov(data = Data.norm, S_Head ~ Breed) %>% tukey_hsd()
N_S_Head <- data.frame(c(N_S_Head_aov[,c(4:5,7)], N_S_Head_pwc[1,8], N_S_Head_pwc[2,8], N_S_Head_pwc[3,8]), row.names = 'N_S_Head')

N_S_Neck_aov <- anova_test(data = Data.norm, S_Neck ~ Breed) 
N_S_Neck_pwc <- aov(data = Data.norm, S_Neck ~ Breed) %>% tukey_hsd()
N_S_Neck <- data.frame(c(N_S_Neck_aov[,c(4:5,7)], N_S_Neck_pwc[1,8], N_S_Neck_pwc[2,8], N_S_Neck_pwc[3,8]), row.names = 'N_S_Neck')

N_S_Torso_aov <- anova_test(data = Data.norm, S_Torso ~ Breed) 
N_S_Torso_pwc <- aov(data = Data.norm, S_Torso ~ Breed) %>% tukey_hsd()
N_S_Torso <- data.frame(c(N_S_Torso_aov[,c(4:5,7)], N_S_Torso_pwc[1,8], N_S_Torso_pwc[2,8], N_S_Torso_pwc[3,8]), row.names = 'N_S_Torso')

N_S_Humerus_aov <- anova_test(data = Data.norm, S_Humerus ~ Breed) 
N_S_Humerus_pwc <- aov(data = Data.norm, S_Humerus ~ Breed) %>% tukey_hsd()
N_S_Humerus <- data.frame(c(N_S_Humerus_aov[,c(4:5,7)], N_S_Humerus_pwc[1,8], N_S_Humerus_pwc[2,8], N_S_Humerus_pwc[3,8]), row.names = 'N_S_Humerus')

N_S_Forearm_aov <- anova_test(data = Data.norm, S_Forearm ~ Breed) 
N_S_Forearm_pwc <- aov(data = Data.norm, S_Forearm ~ Breed) %>% tukey_hsd()
N_S_Forearm <- data.frame(c(N_S_Forearm_aov[,c(4:5,7)], N_S_Forearm_pwc[1,8], N_S_Forearm_pwc[2,8], N_S_Forearm_pwc[3,8]), row.names = 'N_S_Forearm')

N_S_Manus_aov <- anova_test(data = Data.norm, S_Manus ~ Breed) 
N_S_Manus_pwc <- aov(data = Data.norm, S_Manus ~ Breed) %>% tukey_hsd()
N_S_Manus <- data.frame(c(N_S_Manus_aov[,c(4:5,7)], N_S_Manus_pwc[1,8], N_S_Manus_pwc[2,8], N_S_Manus_pwc[3,8]), row.names = 'N_S_Manus')

N_S_ThigS_aov <- anova_test(data = Data.norm, S_Thigh ~ Breed) 
N_S_ThigS_pwc <- aov(data = Data.norm, S_Thigh ~ Breed) %>% tukey_hsd()
N_S_Thigh <- data.frame(c(N_S_ThigS_aov[,c(4:5,7)], N_S_ThigS_pwc[1,8], N_S_ThigS_pwc[2,8], N_S_ThigS_pwc[3,8]), row.names = 'N_S_Thigh')

N_S_Shank_aov <- anova_test(data = Data.norm, S_Shank ~ Breed) 
N_S_Shank_pwc <- aov(data = Data.norm, S_Shank ~ Breed) %>% tukey_hsd()
N_S_Shank <- data.frame(c(N_S_Shank_aov[,c(4:5,7)], N_S_Shank_pwc[1,8], N_S_Shank_pwc[2,8], N_S_Shank_pwc[3,8]), row.names = 'N_S_Shank')

N_S_TMT_aov <- anova_test(data = Data.norm, S_TMT ~ Breed) 
N_S_TMT_pwc <- aov(data = Data.norm, S_TMT ~ Breed) %>% tukey_hsd()
N_S_TMT <- data.frame(c(N_S_TMT_aov[,c(4:5,7)], N_S_TMT_pwc[1,8], N_S_TMT_pwc[2,8], N_S_TMT_pwc[3,8]), row.names = 'N_S_TMT')

N_S_Pes_aov <- anova_test(data = Data.norm, S_Pes ~ Breed) 
N_S_Pes_pwc <- aov(data = Data.norm, S_Pes ~ Breed) %>% tukey_hsd()
N_S_Pes <- data.frame(c(N_S_Pes_aov[,c(4:5,7)], N_S_Pes_pwc[1,8], N_S_Pes_pwc[2,8], N_S_Pes_pwc[3,8]), row.names = 'N_S_Pes')

###Format Normalised AOV Results###
N_List <- do.call("rbind", list(
N_L_Humerus, N_L_Forearm, N_L_CMC, N_L_Manus, N_L_Thigh, N_L_Shank, N_L_TMT, N_L_Pes, N_L_Neck, 
N_L_Shoulder, N_L_Sternum, N_L_GA, N_L_Hip,
N_H_Head, N_H_Neck, N_H_Torso, N_H_Humerus, N_H_Forearm, N_H_Manus, N_H_Thigh, N_H_Shank, N_H_TMT, N_H_Pes,
N_S_Head, N_S_Neck, N_S_Torso, N_S_Humerus, N_S_Forearm, N_S_Manus, N_S_Thigh, N_S_Shank, N_S_TMT, N_S_Pes))


###Export AOV Results###

write.xlsx(R_List, file = 'AOV_Res.xlsx', sheetName = 'Raw')
write.xlsx(N_List, file = 'AOV_Res.xlsx', sheetName = 'Normalised', append = TRUE)